#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR
#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif

void BX_CPU_C::EXEC_mov_O16AX_I16dsD16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
AX=arg0;

}

void BX_CPU_C::EXEC_mov_O16AX_I16dsD32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
AX=arg0;

}

void BX_CPU_C::EXEC_mov_O16AX_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
AX=arg0;

}

void BX_CPU_C::EXEC_mov_O16BP_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
BP=arg0;

}

void BX_CPU_C::EXEC_mov_O16BX_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
BX=arg0;

}

void BX_CPU_C::EXEC_mov_O16CX_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
CX=arg0;

}

void BX_CPU_C::EXEC_mov_O16DI_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
DI=arg0;

}

void BX_CPU_C::EXEC_mov_O16DX_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
DX=arg0;

}

void BX_CPU_C::EXEC_mov_O16SI_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
SI=arg0;

}

void BX_CPU_C::EXEC_mov_O16SP_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
SP=arg0;

}

void BX_CPU_C::EXEC_mov_O16dsD16_I16AX(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

arg1=AX;

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16dsD16_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit16u disp;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+2);
immdat|=(*(imm+2+1))<<8;
#else
immdat=*((Bit16u*)(imm+2));
#endif

arg0_off=disp;

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16dsD16_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16dsD32_I16AX(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

arg1=AX;

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16dsD32_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit32u disp;
Bit16u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
#else
immdat=*((Bit16u*)(imm+4));
#endif

arg0_off=disp;

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16dsD32_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16dsD32_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16dsrm161_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16dsrm161_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16dsrm321_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16dsrm321_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16dsrm322D32_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
#else
immdat=*((Bit16u*)(imm+4));
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16dsrm322D32_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16r1rm161D16_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+2);
immdat|=(*(imm+2+1))<<8;
#else
immdat=*((Bit16u*)(imm+2));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16r1rm161D16_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16r1rm161D8_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;
Bit16u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
#else
immdat=*((Bit16u*)(imm+1));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16r1rm161D8_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16r2rm162D16_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+2);
immdat|=(*(imm+2+1))<<8;
#else
immdat=*((Bit16u*)(imm+2));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16r2rm162D16_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16r2rm162D8_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;
Bit16u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
#else
immdat=*((Bit16u*)(imm+1));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16r2rm162D8_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16r2rm162_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16r2rm162_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm321D32_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
#else
immdat=*((Bit16u*)(imm+4));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm321D32_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm321D32_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm321D8_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;
Bit16u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
#else
immdat=*((Bit16u*)(imm+1));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm321D8_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm321D8_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm321_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm321_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm323D32_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
#else
immdat=*((Bit16u*)(imm+4));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm323D32_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm323D8_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;
Bit16u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
#else
immdat=*((Bit16u*)(imm+1));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm323D8_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm323_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

arg1=immdat;

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16rarm323_I16regr2(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

arg1=BX_READ_16BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O16regm_I16imm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit8u last;
Bit16u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
BX_READ_16BIT_REG((last&0x7))=arg0;

}

void BX_CPU_C::EXEC_mov_O16regm_I16regr(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_READ_16BIT_REG((last&0x38)/8);

arg0=arg1;
BX_READ_16BIT_REG((last&0x7))=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr2_I16dsD32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr2_I16dsrm322D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr2_I16rarm321(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr2_I16rarm321D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr2_I16rarm321D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr2_I16rarm323(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr2_I16rarm323D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr2_I16rarm323D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr_I16dsD16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr_I16dsD32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr_I16dsrm161(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr_I16dsrm321(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr_I16r1rm161D16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr_I16r1rm161D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr_I16r2rm162(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr_I16r2rm162D16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr_I16r2rm162D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr_I16rarm321D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr_I16rarm321D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O16regr_I16regm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_READ_16BIT_REG((last&0x7));

arg0=arg1;
BX_READ_16BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32EAX_I32dsD16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
EAX=arg0;

}

void BX_CPU_C::EXEC_mov_O32EAX_I32dsD32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
EAX=arg0;

}

void BX_CPU_C::EXEC_mov_O32EAX_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
EAX=arg0;

}

void BX_CPU_C::EXEC_mov_O32EBP_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
EBP=arg0;

}

void BX_CPU_C::EXEC_mov_O32EBX_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
EBX=arg0;

}

void BX_CPU_C::EXEC_mov_O32ECX_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
ECX=arg0;

}

void BX_CPU_C::EXEC_mov_O32EDI_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
EDI=arg0;

}

void BX_CPU_C::EXEC_mov_O32EDX_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
EDX=arg0;

}

void BX_CPU_C::EXEC_mov_O32ESI_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
ESI=arg0;

}

void BX_CPU_C::EXEC_mov_O32ESP_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
ESP=arg0;

}

void BX_CPU_C::EXEC_mov_O32dsD16_I32EAX(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

arg1=EAX;

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32dsD16_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit16u disp;
Bit32u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+2);
immdat|=(*(imm+2+1))<<8;
immdat|=(*(imm+2+2))<<16;
immdat|=(*(imm+2+3))<<24;
#else
immdat=*((Bit32u*)(imm+2));
#endif

arg0_off=disp;

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32dsD16_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32dsD32_I32EAX(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

arg1=EAX;

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32dsD32_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit32u disp;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
immdat|=(*(imm+4+2))<<16;
immdat|=(*(imm+4+3))<<24;
#else
immdat=*((Bit32u*)(imm+4));
#endif

arg0_off=disp;

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32dsD32_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32dsD32_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32dsrm161_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32dsrm161_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32dsrm321_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32dsrm321_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32dsrm322D32_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
immdat|=(*(imm+4+2))<<16;
immdat|=(*(imm+4+3))<<24;
#else
immdat=*((Bit32u*)(imm+4));
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32dsrm322D32_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32r1rm161D16_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+2);
immdat|=(*(imm+2+1))<<8;
immdat|=(*(imm+2+2))<<16;
immdat|=(*(imm+2+3))<<24;
#else
immdat=*((Bit32u*)(imm+2));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32r1rm161D16_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32r1rm161D8_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;
Bit32u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
immdat|=(*(imm+1+2))<<16;
immdat|=(*(imm+1+3))<<24;
#else
immdat=*((Bit32u*)(imm+1));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32r1rm161D8_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32r2rm162D16_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+2);
immdat|=(*(imm+2+1))<<8;
immdat|=(*(imm+2+2))<<16;
immdat|=(*(imm+2+3))<<24;
#else
immdat=*((Bit32u*)(imm+2));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32r2rm162D16_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32r2rm162D8_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;
Bit32u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
immdat|=(*(imm+1+2))<<16;
immdat|=(*(imm+1+3))<<24;
#else
immdat=*((Bit32u*)(imm+1));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32r2rm162D8_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32r2rm162_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32r2rm162_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm321D32_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
immdat|=(*(imm+4+2))<<16;
immdat|=(*(imm+4+3))<<24;
#else
immdat=*((Bit32u*)(imm+4));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm321D32_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm321D32_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm321D8_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;
Bit32u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
immdat|=(*(imm+1+2))<<16;
immdat|=(*(imm+1+3))<<24;
#else
immdat=*((Bit32u*)(imm+1));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm321D8_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm321D8_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm321_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm321_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm323D32_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+4);
immdat|=(*(imm+4+1))<<8;
immdat|=(*(imm+4+2))<<16;
immdat|=(*(imm+4+3))<<24;
#else
immdat=*((Bit32u*)(imm+4));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm323D32_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm323D8_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;
Bit32u immdat;

last=*(imm-1);
disp=*imm;
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+1);
immdat|=(*(imm+1+1))<<8;
immdat|=(*(imm+1+2))<<16;
immdat|=(*(imm+1+3))<<24;
#else
immdat=*((Bit32u*)(imm+1));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm323D8_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm323_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

arg1=immdat;

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32rarm323_I32regr2(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

arg1=BX_READ_32BIT_REG((last2&0x38)/8);

arg0=arg1;
write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O32regm_I32imm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit8u last;
Bit32u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg1=immdat;

arg0=arg1;
BX_READ_32BIT_REG((last&0x7))=arg0;

}

void BX_CPU_C::EXEC_mov_O32regm_I32regr(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_READ_32BIT_REG((last&0x38)/8);

arg0=arg1;
BX_READ_32BIT_REG((last&0x7))=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr2_I32dsD32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr2_I32dsrm322D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr2_I32rarm321(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr2_I32rarm321D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr2_I32rarm321D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr2_I32rarm323(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr2_I32rarm323D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr2_I32rarm323D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last2&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr_I32dsD16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr_I32dsD32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr_I32dsrm161(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr_I32dsrm321(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr_I32r1rm161D16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr_I32r1rm161D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr_I32r2rm162(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr_I32r2rm162D16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr_I32r2rm162D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr_I32rarm321D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr_I32rarm321D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O32regr_I32regm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_READ_32BIT_REG((last&0x7));

arg0=arg1;
BX_READ_32BIT_REG((last&0x38)/8)=arg0;

}

void BX_CPU_C::EXEC_mov_O8AH_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);


arg1=immdat;

arg0=arg1;
AH=arg0;

}

void BX_CPU_C::EXEC_mov_O8AL_I8dsD16(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
AL=arg0;

}

void BX_CPU_C::EXEC_mov_O8AL_I8dsD32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
AL=arg0;

}

void BX_CPU_C::EXEC_mov_O8AL_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);


arg1=immdat;

arg0=arg1;
AL=arg0;

}

void BX_CPU_C::EXEC_mov_O8BH_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);


arg1=immdat;

arg0=arg1;
BH=arg0;

}

void BX_CPU_C::EXEC_mov_O8BL_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);


arg1=immdat;

arg0=arg1;
BL=arg0;

}

void BX_CPU_C::EXEC_mov_O8CH_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);


arg1=immdat;

arg0=arg1;
CH=arg0;

}

void BX_CPU_C::EXEC_mov_O8CL_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);


arg1=immdat;

arg0=arg1;
CL=arg0;

}

void BX_CPU_C::EXEC_mov_O8DH_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);


arg1=immdat;

arg0=arg1;
DH=arg0;

}

void BX_CPU_C::EXEC_mov_O8DL_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u immdat;

immdat=*(imm+0);


arg1=immdat;

arg0=arg1;
DL=arg0;

}

void BX_CPU_C::EXEC_mov_O8dsD16_I8AL(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

arg1=AL;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsD16_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit16u disp;
Bit8u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off=disp;

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsD16_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsD16_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsD32_I8AL(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

arg1=AL;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsD32_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit32u disp;
Bit8u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off=disp;

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsD32_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsD32_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsD32_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsD32_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsrm161_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsrm161_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsrm161_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsrm321_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsrm321_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsrm321_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsrm322D32_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsrm322D32_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8dsrm322D32_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r1rm161D16_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r1rm161D16_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r1rm161D16_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r1rm161D8_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r1rm161D8_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r1rm161D8_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r2rm162D16_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif
immdat=*(imm+2);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r2rm162D16_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r2rm162D16_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r2rm162D8_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r2rm162D8_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r2rm162D8_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r2rm162_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r2rm162_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8r2rm162_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321D32_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321D32_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321D32_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321D32_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321D32_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321D8_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321D8_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321D8_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321D8_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321D8_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm321_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7);

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm323D32_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;
Bit8u immdat;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif
immdat=*(imm+4);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm323D32_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm323D32_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm323D8_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;
Bit8u immdat;

last=*(imm-1);
disp=*imm;
immdat=*(imm+1);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm323D8_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm323D8_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm323_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

arg1=immdat;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm323_I8reghr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8rarm323_I8reglr2(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

arg0=arg1;
write_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_mov_O8reghm_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);


arg1=immdat;

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghm_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghm_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr2_I8dsD32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr2_I8dsrm322D32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr2_I8rarm321(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr2_I8rarm321D32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr2_I8rarm321D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr2_I8rarm323(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr2_I8rarm323D32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr2_I8rarm323D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8dsD16(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8dsD32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8dsrm161(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8dsrm321(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8r1rm161D16(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8r1rm161D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8r2rm162(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8r2rm162D16(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8r2rm162D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8rarm321D32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8rarm321D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8reghm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reghr_I8reglm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglm_I8imm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u last;
Bit8u immdat;

last=*(imm-1);
immdat=*(imm+0);


arg1=immdat;

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglm_I8reghr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglm_I8reglr(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr2_I8dsD32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr2_I8dsrm322D32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr2_I8rarm321(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr2_I8rarm321D32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr2_I8rarm321D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr2_I8rarm323(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr2_I8rarm323D32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr2_I8rarm323D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8dsD16(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off=disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8dsD32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off=disp;

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8dsrm161(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8dsrm321(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = BX_READ_32BIT_REG(last&0x7);

read_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8r1rm161D16(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8r1rm161D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8r2rm162(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;

last=*(imm-1);

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8r2rm162D16(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8r2rm162D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit16u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8rarm321D32(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8rarm321D8(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit32u arg1_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg1_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg1_off,&arg1);

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8reghm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}

void BX_CPU_C::EXEC_mov_O8reglr_I8reglm(int seg,Bit8u* imm)
{
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg1=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;

arg0=arg1;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg0;

}
